%read labels from file and put them into LABELS

%LABELS = textread(LABELS_FILE);
fid = fopen(LABELS_FILE, 'r');

LABELS = [];
while 1
    tline = fgetl(fid);
    if ~ischar(tline), break, end
    LABELS(end+1) = str2num(tline);
end

fclose(fid);

LABELS = LABELS(~EXCLUDE_GENES);

%read gene names

NAMES = textread(OUT_GENES_FILE, '%s');
NAMES = NAMES(2:2:end);
NAMES = NAMES(~EXCLUDE_GENES);

if length(LABELS) ~= length(NAMES)
    fprintf('Error: labels in %s do not match with the number of genes\n', LABELS_FILE);
    input('Please, fix your labels file and then press Enter\n')
end